/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.eui;

import ibm.nways.analysis.dpCommon.DpResourceInstance;
import ibm.nways.analysis.dpCommon.MultipleNodePOAnalysis;
import ibm.nways.analysis.dpCommon.ThresholdAnalysis;
import ibm.nways.nhm.eui.MultipleNodeAnalysisPanel;
import ibm.nways.nhm.eui.NhmApplet;
import ibm.nways.nhm.eui.ThresholdAnalyzer;
import ibm.nways.ras.Traces;
import java.awt.ScrollPane;
import java.util.ResourceBundle;

public class MultipleNodeAnalysisApplet
extends NhmApplet
implements ThresholdAnalyzer {
    private static final int COMMA = 44;
    private static final int EQUAL = 61;
    private String[] hostNames;
    private DpResourceInstance[] instanceIds;
    private String poId;
    private ScrollPane scroller;
    private ResourceBundle res = ResourceBundle.getBundle("ibm.nways.nhm.eui.AppletResources");

    public void init() {
        super.init();
        try {
            Traces.initializeTraces(this);
        }
        catch (Exception exception) {
            System.out.println("Exception occurred in init() of DpAdmin");
            exception.printStackTrace();
        }
        this.showStatus(this.res.getString("s_loadingParms"));
        this.poId = this.getParameter("polling_object_id");
        String string = this.getParameter("port_num");
        try {
            this.portNumber = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.portNumber = 2099;
        }
        this.createDataRetriever();
        super.getTimeParms();
        this.hostNames = super.getHostParms();
        this.instanceIds = new DpResourceInstance[this.hostNames.length];
        String string2 = null;
        String string3 = null;
        try {
            int n = 0;
            while (n < this.hostNames.length) {
                string = this.getParameter("instance_" + String.valueOf(n + 1));
                if (string != null) {
                    this.instanceIds[n] = new DpResourceInstance();
                    int n2 = string.indexOf(44);
                    int n3 = string.indexOf(61);
                    while (n3 != -1) {
                        string2 = string.substring(0, n3);
                        if (n2 == -1) {
                            string3 = string.substring(n3 + 1);
                            n3 = -1;
                        } else {
                            string3 = string.substring(n3 + 1, n2);
                            n2 = string.indexOf(44, n2 + 1);
                            n3 = string.indexOf(61, n2 + 1);
                        }
                        this.instanceIds[n].dpAddInstanceDescriptor(string2, string3);
                    }
                } else {
                    this.instanceIds[n] = null;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            Traces.logException(exception);
            exception.printStackTrace();
        }
        MultipleNodePOAnalysis multipleNodePOAnalysis = this.setData();
        if (multipleNodePOAnalysis != null) {
            this.scroller = new ScrollPane();
            MultipleNodeAnalysisPanel multipleNodeAnalysisPanel = new MultipleNodeAnalysisPanel(this, this.poId, multipleNodePOAnalysis);
            this.scroller.add(multipleNodeAnalysisPanel);
            this.add("Center", this.scroller);
            super.addButtons();
            return;
        }
        this.showStatus(this.res.getString("s_retrievalError"));
    }

    private MultipleNodePOAnalysis setData() {
        this.showStatus(this.res.getString("s_retrievingData"));
        MultipleNodePOAnalysis multipleNodePOAnalysis = this.dataRetriever.retrieveMultipleNodeAnalysis(this.hostNames, this.instanceIds, this.poId, this.startDate, this.endDate);
        this.showStatus(this.res.getString("s_retrievalComplete"));
        return multipleNodePOAnalysis;
    }

    public void newTimeRangeSelected() {
        MultipleNodePOAnalysis multipleNodePOAnalysis = this.setData();
        this.scroller.removeAll();
        if (multipleNodePOAnalysis != null) {
            MultipleNodeAnalysisPanel multipleNodeAnalysisPanel = new MultipleNodeAnalysisPanel(this, this.poId, multipleNodePOAnalysis);
            this.scroller.add(multipleNodeAnalysisPanel);
        } else {
            this.showStatus(this.res.getString("s_retrievalError"));
        }
        this.validate();
    }

    public String getTimeRangeString() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(this.df.format(this.startDate));
        stringBuffer.append(" - ");
        stringBuffer.append(this.df.format(this.endDate));
        return stringBuffer.toString();
    }

    public ThresholdAnalysis getThresholdAnalysis(String string, String string2) {
        return null;
    }
}

